package eu.qimpress.ide.project.repository.folders;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;

import eu.qimpress.ide.project.Activator;
import eu.qimpress.ide.project.RepositoryAccess;
import eu.qimpress.samm.staticstructure.Interface;

public class InterfacesFolder extends AbstractFolder {

	public InterfacesFolder(RepositoryAccess repoAccess, RepositoryFolder parent) {
		super(repoAccess, parent);
	}

	@Override
	public Object[] getChildren(Object o) {
		EList<Interface> interfaces = repositoryAccess.getRepository().getInterface();
		
		return interfaces.toArray();
		
	}

	@Override
	public ImageDescriptor getImageDescriptor(Object object) {
		return Activator.getImageDescriptor("icons/components-folder-16.png");		
	}

	@Override
	public String getLabel(Object o) {
		return "Interfaces";		
	}

}
