package eu.qimpress.ide.project.repository.folders;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageDescriptor;

import eu.qimpress.ide.project.Activator;
import eu.qimpress.ide.project.RepositoryAccess;
import eu.qimpress.samm.staticstructure.ComponentType;

public class ComponentsFolder extends AbstractFolder {

		
	public ComponentsFolder(RepositoryAccess repositoryAccess, RepositoryFolder parent) {
		super(repositoryAccess, parent);		
	}
	
	@Override
	public Object[] getChildren(Object o) {
		
		EList<ComponentType> comps = repositoryAccess.getRepository().getComponenttype();
		
		return comps.toArray();
	}

	@Override
	public ImageDescriptor getImageDescriptor(Object object) {
		return Activator.getImageDescriptor("icons/components-folder-16.png");
	}

	@Override
	public String getLabel(Object o) {
		return "Components";
	}

}
