package eu.qimpress.ide.project.repository.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

import eu.qimpress.ide.project.adapters.IConcreteSyntaxFile;
import eu.qimpress.samm.core.NamedEntity;

public class OpenEdificeEditorAction implements IObjectActionDelegate {
	
	private Shell shell = null;	
	private NamedEntity entity = null;

	@Override
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.shell = targetPart.getSite().getShell();		
	}

	@Override
	public void run(IAction action) {		
				
		boolean resultOK = true;
		
		try {
			IConcreteSyntaxFile lazyDSLFile = (IConcreteSyntaxFile) Platform.getAdapterManager().getAdapter(entity, IConcreteSyntaxFile.class);
			
			if (lazyDSLFile != null) {
				// perform transformation
				IFile dslFile = lazyDSLFile.getFile();
				
				if (dslFile != null) {							
					openEditor(dslFile);
				} else {
					resultOK = false;
				}
			} else {
				resultOK = false;
			}
//		} catch (PartInitException e) {
		} catch (Throwable e) {
			resultOK = false;
			e.printStackTrace();
		} finally {
			if (!resultOK) {
				MessageDialog.openError(shell, "Error occured during opening editor", "Cannot open editor for the entity " + entity.getName());
			}
		}
	}
	
	/**
	 * Open Edifice editor for given file.
	 * 
	 * @param file input for editor.
	 * 
	 * @throws PartInitException if editor cannot be opened 
	 */
	protected void openEditor(IFile dslFile) throws PartInitException  {
		// prepare editor input
		IEditorInput editorInput = new FileEditorInput(dslFile);				
		
		// open editor
		IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();		
		IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
		workbenchPage.openEditor(editorInput, "eu.qimpress.dsl.EdificeHolder");
	}

	@SuppressWarnings("unchecked")
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection != null && selection instanceof IStructuredSelection) {
			IStructuredSelection sselection = (IStructuredSelection) selection;
			
			if (!sselection.isEmpty()) {
				entity = (NamedEntity) sselection.getFirstElement();				
			} 
		}
		
	}

	
}
