/**
 * 
 */
package eu.qimpress.ide.project.adapters;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

import eu.qimpress.samm.core.NamedEntity;

/**
 * @author Michal Malohlava
 *
 */
public class XtextResourceBasedConcreteSyntaxFile implements IConcreteSyntaxFile {
	
	private NamedEntity namedEntity;	
	private IFile outputFile;

	
	public XtextResourceBasedConcreteSyntaxFile(NamedEntity namedEntity, IFile outputFile) {		
		this.namedEntity = namedEntity;
		this.outputFile = outputFile;
	}

	/* (non-Javadoc)
	 * @see eu.qimpress.ide.project.adapters.IConcreteSyntaxFile#getFile()
	 */
	@Override
	public IFile getFile() {
		IFile result = null; 
		
		try {
			generate();
			result = this.outputFile;
		} catch (Exception e) {
			e.printStackTrace();
		}		
		return null;
	}
	
	protected void generate() throws IOException {
		// create temporary DSL
		XtextResourceSet rSet = new XtextResourceSet();
		Resource resource = rSet.createResource(URI.createFileURI(outputFile.getLocationURI().toString()));
		
		// save resource				
		resource.getContents().add(namedEntity.eContainer());
		Map<String, Boolean> options = new HashMap<String, Boolean>();
		options.put(XtextResource.OPTION_FORMAT, Boolean.TRUE);
		options.put(XtextResource.OPTION_RESOLVE_ALL, Boolean.FALSE);
		
		resource.save(options);		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	@Override
	public Object getAdapter(Class adapter) {
		return null;
	}

}
