/**
 * 
 */
package eu.qimpress.ide.project.adapters;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

import eu.qimpress.samm.core.NamedEntity;

/**
 * Adapter factory for converting NamedEntities to a file stored on the filesystem in the local storage.
 * 
 * It uses for producing concrete syntax serialization capability of EMF resources.
 * 
 * @author Michal Malohlava
 * @deprecated currently deprecated
 */
public class XTextResourceBasedConcreteSyntaxAdapterFactory extends AbstractConcreteSyntaxAdapterFactory {
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdapterFactory#getAdapter(java.lang.Object, java.lang.Class)
	 */
	@Override
	public Object getAdapter(Object adaptableObject, Class adapterType) {
		if (adapterType.equals(IConcreteSyntaxFile.class)) {
			if (adaptableObject instanceof NamedEntity) {
				NamedEntity entity = (NamedEntity) adaptableObject;
				IProject project = getProject(entity.eResource().getURI());
								
				try {
					// create file on the file system
					String fileName = entity.getName() + "_" + entity.getId() + "." + "edifice";
					IFile outputFile = getOutputFile(fileName, project);
					
					return new XtextResourceBasedConcreteSyntaxFile(entity, outputFile);
				} catch (CoreException e) {
					
					e.printStackTrace();
				}				
			}			
		}
		return null;
	}
}
