/**
 * 
 */
package eu.qimpress.ide.project.adapters;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

import eu.qimpress.samm.staticstructure.provider.StaticstructureItemProviderAdapterFactory;

/**
 * Simple factory providing access to generated EMF factories for SAMM.edit.
 * 
 * @author Michal Malohlava
 *
 */
public class SammComposedAdapterFactoryProvider {
	
	private static ComposedAdapterFactory adapterFactory;
	
	public final static List<AdapterFactory> createFactoryList() {
		List<AdapterFactory> list = new ArrayList<AdapterFactory>();
		
		list.add(new StaticstructureItemProviderAdapterFactory());
		
		return list;
	}
	
	public final static ComposedAdapterFactory getAdapterFactory() {
		if (adapterFactory == null) {
			adapterFactory = new ComposedAdapterFactory(createFactoryList());
		}
		
		return adapterFactory;
	}
	

}
