package eu.qimpress.ide.project.adapters;

import java.util.HashMap;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;

import eu.qimpress.ide.project.RepositoryAccess;

public class QImpressProjectAdapterFactory implements IAdapterFactory {

	private static HashMap<IProject, RepositoryAccess> repositoryAccessMap = new HashMap<IProject, RepositoryAccess>();
	
	public Object getAdapter(Object adaptableObject, Class adapterType) {
		IProject project = (IProject)adaptableObject;
		
		if (adapterType == RepositoryAccess.class) {
			RepositoryAccess ret = repositoryAccessMap.get(project);
			
			if (ret == null) {
				ret = new RepositoryAccess(project);
				
				repositoryAccessMap.put(project, ret);
			}
			
			return ret;
		}

		return null;
	}

	public Class[] getAdapterList() {
		return new Class[] { RepositoryAccess.class };
	}

}
