/**
 * 
 */
package eu.qimpress.ide.project.adapters;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.core.WorkflowRunner;

import eu.qimpress.samm.core.NamedEntity;

/**
 * Implementation of {@link IConcreteSyntaxFile} interface based on MWE transformation workflow.
 * 
 * Transforms given NamedEntity into a concrete file stored in a project's hidden directory. 
 * 
 * @author Michal Malohlava
 *
 */
public class MWEBasedConcreteSyntaxFile implements IConcreteSyntaxFile {
	
	private NamedEntity namedEntity;
	private IProject project;
	private IFile file;
	

	public MWEBasedConcreteSyntaxFile(NamedEntity namedEntity, IFile file) {		
		this.namedEntity = namedEntity;
		this.project = file.getProject();
		this.file = file;
	}

	/* (non-Javadoc)
	 * @see eu.qimpress.ide.project.adapters.IConcreteSyntaxFile#getFile()
	 */
	@Override
	public IFile getFile() {
		IFile result = null; 
		
		try {
			generate();
			result = this.file;
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return result;
	}

	protected void generate() throws URISyntaxException, IOException {
		// create temporary DSL file via calling MWE workflow
		String mweFile;				
		mweFile = URIUtil.toFile(FileLocator.toFileURL(eu.qimpress.ide.project.Activator.getDefault().getBundle().getEntry("/workflow/EdificeGenerator.mwe")).toURI()).getAbsolutePath();
		Map<String, String> properties = new HashMap<String, String>(1);					
		Map<String, NamedEntity> slotContents = Collections.singletonMap("model", namedEntity);
		
		properties.put("outputFolder", URIUtil.toFile(file.getParent().getLocationURI()).getAbsolutePath());
		
		new WorkflowRunner().run(mweFile, null, properties, slotContents);
		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	@Override
	public Object getAdapter(Class adapter) {
		
		if (adapter.equals(NamedEntity.class)) {
			return namedEntity;
		} else if (adapter.equals(EObject.class)) {
			return namedEntity;
		} else if (adapter.equals(IProject.class)) {
			return project;
		}
		
		return null;
	}

}
