package eu.qimpress.ide.project;

import java.io.IOException;
import java.util.Collections;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;

public class RepositoryAccess {
	static public final String repositoryFile = ".repository/repository.xml";
	
	private Repository repository; 
	private IProject project;
	
	public RepositoryAccess(IProject prj) {
		project = prj;
	}
	
	public Repository getRepository() {
		if (repository == null) {
			reloadRepository();
		}
		
		return repository;
	}
	
	public void reloadRepository() {
		try {
			StaticstructurePackage ssPackage = StaticstructurePackage.eINSTANCE;
			
			ResourceSet resourceSet = new ResourceSetImpl();
			resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(Resource.Factory.Registry.DEFAULT_EXTENSION, new XMIResourceFactoryImpl());
	
			URI repoURI = URI.createPlatformResourceURI(project.getName() + "/" + repositoryFile, true);
			Resource resource = resourceSet.getResource(repoURI, true);
	
			EObject dummy = resource.getContents().get(0);
			if (dummy instanceof Repository) {
				repository = (Repository)dummy;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void setupRepository() {
		if (!project.getFile(repositoryFile).exists()) {
			try {				
				StaticstructureFactory ssFactory = StaticstructureFactory.eINSTANCE;
				
				Repository repo = ssFactory.createRepository();		
				repo.setName("Q-Impress Project Repository");
				
				ResourceSet resourceSet = new ResourceSetImpl();
		
				resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(Resource.Factory.Registry.DEFAULT_EXTENSION, new XMIResourceFactoryImpl());
		
				try {
					((IFolder)project.getFile(repositoryFile).getParent()).create(true, true, null);
				} catch (CoreException e) {
				}
				
				URI repoURI = URI.createPlatformResourceURI(project.getName() + "/" + repositoryFile, true);
				Resource resource = resourceSet.createResource(repoURI);
		
				// Add the book and writer objects to the contents.
				resource.getContents().add(repo);
		
				// Save the contents of the resource to the file system.
				resource.save(Collections.EMPTY_MAP);
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	
	public IProject getProject() {
		return project;
	}
}
