package eu.qimpress.ide.project;

import java.util.Map;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class QImpressBuilder extends IncrementalProjectBuilder {
	public static final String BUILDER_ID = "eu.qimpress.ide.project.QImpressBuilder";

	private static final String MARKER_TYPE = "eu.qimpress.ide.project.RepositoryProblem";

	protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
		
		IProject project = getProject();
		project.deleteMarkers(MARKER_TYPE, false, IResource.DEPTH_ZERO);

		RepositoryAccess repoAccess = (RepositoryAccess)project.getAdapter(RepositoryAccess.class);
		repoAccess.reloadRepository();
		
		if (repoAccess.getRepository() == null) {
			IMarker marker = project.createMarker(MARKER_TYPE);
			marker.setAttribute(IMarker.MESSAGE, "Repository file not found or damaged.");
			marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_ERROR);
		}

		return null;
	}
}
