package eu.qimpress.ide.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.model.WorkbenchContentProvider;

import eu.qimpress.ide.project.repository.folders.RepositoryFolder;

public class ProjectTreeContentProvider extends WorkbenchContentProvider implements ITreeContentProvider {

	@Override
	public Object[] getChildren(Object element) {
		if (element instanceof IProject) {
			IProject project = (IProject)element;
			RepositoryAccess repoAccess = (RepositoryAccess)project.getAdapter(RepositoryAccess.class);

			return new Object[] { new RepositoryFolder(repoAccess, element)};
					} else {
			return super.getChildren(element);
		}
	}

}
