package eu.qimpress.ide.analysis.internal;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AnalysisTaskSelectionTab extends AbstractLaunchConfigurationTab {

	public static final String ATM_FILE = "ATM File";
	
	protected Text atmFileText;
	
	@Override
	public void createControl(Composite parent) {
		Composite rootContainer = new Composite(parent, SWT.NULL);
		rootContainer.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		rootContainer.setLayout(new GridLayout(3, false));

		Label atmFileLabel = new Label(rootContainer, SWT.NONE);
		atmFileLabel.setText("Analysis Task:");
		
		atmFileText = new Text(rootContainer, SWT.SINGLE | SWT.BORDER);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = 200;
		atmFileText.setLayoutData(data);
		atmFileText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				updateLaunchConfigurationDialog();
			}
		});
		
		Button atmFileSelectionButton = new Button(rootContainer, SWT.PUSH);
		atmFileSelectionButton.setText("Browse");
		atmFileSelectionButton.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent e) {
			}

			public void widgetSelected(SelectionEvent e) {
				IFile lastSelection = null;
				try {
					lastSelection = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromPortableString(atmFileText.getText()));
				} catch (Exception ex) {}
				
				PatternFilter filter = new PatternFilter();
				filter.setPattern("*.agen");
				List<ViewerFilter> filters = new LinkedList<ViewerFilter>();
				filters.add(filter);
				try {
				IFile[] files = WorkspaceResourceDialog.openFileSelection(getShell(), "Select analysis description ...", null, false, new Object[] {lastSelection}, null);
								
				if (files.length > 0) {
					atmFileText.setText(files[0].getFullPath().toPortableString());
				}
				} catch (Throwable ex) {
					ex.printStackTrace();
				}
			}			
		});
		
		setControl(rootContainer);
	}

	@Override
	public String getName() {
		return "Analysis Task Selection";
	}
	
	@Override
	public Image getImage() {
		return Activator.getImageDescriptor("icons/qimpress-logo-16.png").createImage();		
	}

	@Override
	public void initializeFrom(ILaunchConfiguration configuration) {
		try {
			String atmFile = configuration.getAttribute(ATM_FILE, "");
			atmFileText.setText(atmFile);
		} catch (CoreException e) {
			e.printStackTrace();
		}
		
	}

	@Override
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		configuration.setAttribute(ATM_FILE, atmFileText.getText());
	}

	@Override
	public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
	}

}
