package eu.qimpress.ide.analysis.internal;
import java.io.IOException;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsoleConstants;
import org.eclipse.ui.console.MessageConsoleStream;

import eu.qimpress.analysis.core.AnalysisTask;
import eu.qimpress.analysis.core.CorePackage;
import eu.qimpress.ide.analysis.IAnalysisTool;


public class AnalysisLaunchConfigurationDelegate extends LaunchConfigurationDelegate {

	@Override
	public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {

		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint point = registry.getExtensionPoint("eu.qimpress.ide.analysis.tools");
		
		// setup console output
		MessageConsoleStream msgOut = Activator.getMessageConsole().newMessageStream();
		Activator.getMessageConsole().clearConsole();
		// show console view
		displayConsoleView();
		
		AnalysisTask analysisTask = null;

		try {
			CorePackage analysisPackage = CorePackage.eINSTANCE;
			
			ResourceSet resourceSet = new ResourceSetImpl();
			resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(Resource.Factory.Registry.DEFAULT_EXTENSION, new XMIResourceFactoryImpl());
	
			URI repoURI = URI.createPlatformResourceURI(configuration.getAttribute(AnalysisTaskSelectionTab.ATM_FILE, (String)null), true);
			Resource resource = resourceSet.getResource(repoURI, true);
	
			EObject dummy = resource.getContents().get(0);
			if (dummy instanceof AnalysisTask) {
				analysisTask = (AnalysisTask)dummy;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		if (analysisTask == null) {
			msgOut.println("Analysis task not found or not alright.");
			
		} else {
		
			IConfigurationElement toolConf = null;
			
			IExtension[] extensions = point.getExtensions();
			extFor: for (IExtension ext : extensions) {
				for (IConfigurationElement conf : ext.getConfigurationElements()) {
					if (conf.getAttribute("id").equals(analysisTask.getTool())) {
						toolConf = conf;
						break extFor;
					}
				}
			}
			
			if (toolConf == null) {
				msgOut.println("Can't find analysis tool for '" + analysisTask.getTool() + "'");

			} else {
			
				IAnalysisTool tool = null;
	
				try {
					tool = (IAnalysisTool)Platform.getBundle(toolConf.getDeclaringExtension().getContributor().getName()).
						loadClass(toolConf.getAttribute("class")).newInstance();
				} catch (Exception e) {
					e.printStackTrace();
				}

				if (tool == null) {
					msgOut.println("Cannot instantiate the associated analysis tool");
				} else {
					
					MessageConsoleStream taskOut = Activator.getMessageConsole().newMessageStream();
					
					tool.launch(analysisTask, taskOut);
					
					try {
						taskOut.close();
					} catch (IOException e) {
					}
				}
			}
		}
		
		try {
			msgOut.close();
		} catch (IOException e) {
		}
	}
	
	/**
	 * Display console view.
	 * 
	 * Opening the console has to be executed asynchronously in UI thread. 
	 * 
	 */
	private void displayConsoleView() {
		Display display = PlatformUI.getWorkbench().getDisplay();		
		if (display != null) display = Display.getDefault();
		
		if (display != null) {
			display.asyncExec(new Runnable() {
				
				@Override
				public void run() {
					try
					{
						IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
						
						if( activeWorkbenchWindow != null )
						{
							IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
							if( activePage != null )
								activePage.showView(IConsoleConstants.ID_CONSOLE_VIEW);
								
						}
						
					} catch (PartInitException partEx) {
						// console view is not showed - this should be reported
					}
					
				}
			});		
			
		}
			
	}

}
