package eu.qimpress.analysis.sampleg;

import org.eclipse.ui.console.MessageConsoleStream;

import eu.qimpress.analysis.core.AnalysisTask;
import eu.qimpress.analysis.generic.GenericAnalysisEObjectParam;
import eu.qimpress.analysis.generic.GenericAnalysisParam;
import eu.qimpress.analysis.generic.GenericAnalysisStringParam;
import eu.qimpress.analysis.generic.GenericAnalysisTask;
import eu.qimpress.ide.analysis.IAnalysisTool;

public class AnalysisTool implements IAnalysisTool {

	public AnalysisTool() {
	}

	@Override
	public void launch(AnalysisTask task, MessageConsoleStream msgStream) {
		msgStream.println("SampleG analysis tool");
		msgStream.println("=====================");
		
		GenericAnalysisTask gtask = (GenericAnalysisTask)task;
		
		for (GenericAnalysisParam param : gtask.getParams()) {
			String value = "";
			
			if (param instanceof GenericAnalysisStringParam) {
				value = ((GenericAnalysisStringParam)param).getValue();
			} else if (param instanceof GenericAnalysisEObjectParam) {
				value = ((GenericAnalysisEObjectParam)param).getValue().toString();
			}
			
			msgStream.println("  " + param.getName() + " = " + value);
		}
	}

}
