/**
 * <copyright>
 * </copyright>
 *
 * $Id: GenericAdapterFactory.java 3 2009-06-18 08:12:39Z mmalohlava $
 */
package eu.qimpress.analysis.generic.util;

import eu.qimpress.analysis.core.AnalysisTask;

import eu.qimpress.analysis.generic.*;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see eu.qimpress.analysis.generic.GenericPackage
 * @generated
 */
public class GenericAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static GenericPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GenericAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = GenericPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GenericSwitch<Adapter> modelSwitch =
		new GenericSwitch<Adapter>() {
			@Override
			public Adapter caseGenericAnalysisTask(GenericAnalysisTask object) {
				return createGenericAnalysisTaskAdapter();
			}
			@Override
			public Adapter caseGenericAnalysisParam(GenericAnalysisParam object) {
				return createGenericAnalysisParamAdapter();
			}
			@Override
			public Adapter caseGenericAnalysisStringParam(GenericAnalysisStringParam object) {
				return createGenericAnalysisStringParamAdapter();
			}
			@Override
			public Adapter caseGenericAnalysisEObjectParam(GenericAnalysisEObjectParam object) {
				return createGenericAnalysisEObjectParamAdapter();
			}
			@Override
			public Adapter caseAnalysisTask(AnalysisTask object) {
				return createAnalysisTaskAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.analysis.generic.GenericAnalysisTask <em>Analysis Task</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.analysis.generic.GenericAnalysisTask
	 * @generated
	 */
	public Adapter createGenericAnalysisTaskAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.analysis.generic.GenericAnalysisParam <em>Analysis Param</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.analysis.generic.GenericAnalysisParam
	 * @generated
	 */
	public Adapter createGenericAnalysisParamAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.analysis.generic.GenericAnalysisStringParam <em>Analysis String Param</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.analysis.generic.GenericAnalysisStringParam
	 * @generated
	 */
	public Adapter createGenericAnalysisStringParamAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.analysis.generic.GenericAnalysisEObjectParam <em>Analysis EObject Param</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.analysis.generic.GenericAnalysisEObjectParam
	 * @generated
	 */
	public Adapter createGenericAnalysisEObjectParamAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.analysis.core.AnalysisTask <em>Analysis Task</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.analysis.core.AnalysisTask
	 * @generated
	 */
	public Adapter createAnalysisTaskAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //GenericAdapterFactory
