package rpg;


/**
 * A main class of the generated program, of the harness for modules.
 */
public class Main {
	/// Name of the generated application configuration file.
	private static final String OUTPUT_CONFIG_FILE = "main.conf";

	public static final long NS_IN_S  = 1000000000;
	public static final long NS_IN_MS = 1000000;
	public static final long NS_IN_US = 1000;
	
	public static final long US_IN_MS = 1000;
	
	private static final long DEFAULT_ACTIVE_WAIT_TIME = 25000;
												// In microseconds.
	
	/** controls whether architectural modules are also measured in isolation
	 *
	 * changes to this variable have to be reflected in generator's  lang_java::generateMeasure
	 */
	static boolean measureIsolatedArchitectures = false;
	
	private static final String MEASURE_ISOLATED_ARCHITECTURES = "measure-architectures";

	private static void print_usage () {
		System.err.println("Available command line options:");
		
		System.err.println("--" + MEASURE_ISOLATED_ARCHITECTURES + " - measure also architectural modules in isolation");
	}
	
	/**
	 * Starting function. Loads a configuration file generated by the
	 * random program generator during the generation of this program, and then
	 * calls the WorkerManager, that does the rest of the work.
	 *
     * @param args the command line arguments, none required or expected
     */
    public static void main(String[] args) {
		int minCycles;
		int minTime;
		int threadCount;
		int clientWaitTime;
		int clientCount;
		int maxMeasuredValues;
		int maxTime;

		// TODO: Use something like GetOpt library (which is GPL though?)
		for (int i = 0; i < args.length; i++) {
			if (args[i].equals("--" + MEASURE_ISOLATED_ARCHITECTURES)) {
				measureIsolatedArchitectures = true;
			} else {
				print_usage ();
				System.exit (1);
			}
		}
		
		try {
			// Load the necessary values from the config file.
			ConfigReader.loadConfig(OUTPUT_CONFIG_FILE);
			minCycles = ConfigReader.getIntItem(ConfigReader.GROUP_APP,
					ConfigReader.ITEM_MIN_CYCLES);
			minTime = ConfigReader.getIntItem(ConfigReader.GROUP_APP,
					ConfigReader.ITEM_MIN_TIME);
			threadCount = ConfigReader.getIntItem(ConfigReader.GROUP_APP,
					ConfigReader.ITEM_THREAD_COUNT);
			clientWaitTime = ConfigReader.getIntItem(ConfigReader.GROUP_APP,
					ConfigReader.ITEM_CLIENT_WAIT_TIME_EX);
			clientCount = ConfigReader.getIntItem(ConfigReader.GROUP_APP,
					ConfigReader.ITEM_CLIENT_COUNT);
			maxTime = ConfigReader.getIntItem(ConfigReader.GROUP_APP,
					ConfigReader.ITEM_TIME_LIMIT);

			maxMeasuredValues = ConfigReader.getIntItem(ConfigReader.GROUP_APP,
					ConfigReader.ITEM_VALUES_STORAGE_MAX_SIZE);
			ModuleTimed.setMaxMeasuredValues(maxMeasuredValues);
			
		} catch (Exception e) {
			System.err.println("Cannot load default config!");
			return;
		}

		/* having more threads than clients has no benefit
		 * and would fail in WorkerManager.getClientRequest()
		 */
		if (clientCount < threadCount) {
			System.err.println ("Warning: there are fewer clients than threads, reducing number of threads to " + clientCount);
			threadCount = clientCount;
		}
		
		// Set up the manager that takes care of running the tasks.
		WorkerManager manager = new WorkerManager();

		Rand.setSeed (System.currentTimeMillis());

		try {
			// start the worker threads
			manager.start (threadCount, clientWaitTime, clientCount, minCycles);
			
			// wait for the worker threads to generate enough cycles and run time, or timeout waiting for that
			manager.waitForWorkers (minTime, maxTime);
	
		    // try to finish gracefully
		    boolean graceful = manager.terminate (true);
			if (!graceful) {
				System.err.println ("Threads did not join within timeout, doing abrupt exit.");
				System.exit (1);
			}
			
			manager.printTimes ();
		} catch (Throwable t) {
			// something went wrong, kill the whole app so the worker threads don't remain running
			t.printStackTrace();
			System.exit (1);
		}
	}
    
}
