/**
 * This is a SPECjvm2008 benchmark "xml.validation". This file was originally
 * Main.java.  The original source code in this file is a subject to
 * the following copyright:
 *
 * Copyright (c) 2008 Standard Performance Evaluation Corporation (SPEC)
 *               All rights reserved.
 *
 * This source code is provided as is, without any express or implied warranty.
 */
package rpg.modules.xmlvalidation;

import rpg.SessionStateHolder;
import rpg.Synchronized;
import rpg.modules.xml.XMLBenchmark;

import java.io.File;
import java.io.IOException;

import java.util.Arrays;
import javax.xml.XMLConstants;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import org.xml.sax.SAXException;

import rpg.modules.common.FileCache;

/**
 * Run this in single mode.
 * No multi threading for this benchmark right now.
 */
@Synchronized
public class XmlvalidationModule extends XMLBenchmark {

	private static final int XSD_NUMBER = 6;
    private static FileCache.CachedFile[] allInstanceBytes;
    private static FileCache.CachedFile[] allSchemaBytes;

    private static String[] schemaNames = {
        "validation_input.xsd",
        "periodic_table.xsd",
        "play.xsd",
        "structure.xsd",
        "po.xsd",
        "personal.xsd"
    };
    private static String[] instanceNames = {
        "validation_input.xml",
        "periodicxsd.xml",
        "much_adoxsd.xml",
        "structure.xml",
        "po.xml",
        "personal.xml"
    };
    /*
    Loops numbers are inversely proportional to xml file size
    file name:				file size		loops number
    "validation_input.xml"	621232			1
    "periodicxsd.xml"		116618			5
    "much_adoxsd.xml"		202133			3
    "structure.xml"			11958			52
    "po.xml"					960				647
    "personal.xml"			1482			419
     */
    private static int loops[] = {
        1,
        5,
        3,
        52,
        647,
        419
    ,

           };
    
    @Override
	public void init() {
		/* Do nothing */
	}

	@Override
	protected void internalWork (SessionStateHolder sessionState) {
		try {
			executeWorkload ();
        } catch (Exception e) {
            throw new RuntimeException (e);
        }
    }

	static void setupBenchmark() {
        String dirName = XMLBenchmark.XML_VALIDATION_INPUT_DIR_PROP;
        try {
            allInstanceBytes = new FileCache.CachedFile[XSD_NUMBER];
            FileCache cache = FileCache.getFileCache();
            for (int i = 0; i < XSD_NUMBER; i++) {
                String name = getFullName(dirName, instanceNames[i]);
                allInstanceBytes[i] = cache.new CachedFile(name);
                allInstanceBytes[i].cache();
            }
            allSchemaBytes = new FileCache.CachedFile[XSD_NUMBER];
            for (int i = 0; i < XSD_NUMBER; i++) {
                String name = getFullName(dirName, schemaNames[i]);
                allSchemaBytes[i] = cache.new CachedFile(name);
                allSchemaBytes[i].cache();
            }

            setupValidators(dirName);
        } catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

	private static Schema[] precompSchemas;

    private static void setupValidators(String dirName) {
		try {
            precompSchemas = new Schema[XSD_NUMBER];
            SchemaFactory sf = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
            sf.setErrorHandler(null);
            for (int i = 0; i < XSD_NUMBER; i++) {
                String xsdFilename = getFullName(dirName, schemaNames[i]);
                File tempURI = new File(xsdFilename);
                Schema precompSchema;
                if (tempURI.isAbsolute()) {
                    precompSchema = sf.newSchema(new StreamSource(allSchemaBytes[i].getStream(),
                            tempURI.toURI().toString()));
                } else {
                    precompSchema = sf.newSchema(new StreamSource(allSchemaBytes[i].getStream(), xsdFilename));
                }
				precompSchemas[i] = precompSchema;
            }
        } catch (SAXException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    private Validator[] schemaBoundValidator;

    private static boolean isSetUp = false;
	
	public XmlvalidationModule() {
		if(!isSetUp) {
		// RPG_EDIT: setupBenchmark() is called this way because the class
			// needes to be set up for a constructor, and it needs to be set up
			// only once.
			setupBenchmark();
			isSetUp = true;
		}
		schemaBoundValidator = new Validator[XSD_NUMBER];
		for (int i = 0; i < XSD_NUMBER; i++) {
			schemaBoundValidator[i] = precompSchemas[i].newValidator();
		}
    }

    private void executeWorkload() throws
            ParserConfigurationException, IOException, SAXException {
        for (int i = 0; i < XSD_NUMBER; i++) {
			// RPG_EDIT: Output is ommited in the rpg project
            //Context.getOut().println("Validating " + instanceNames[i]);
            doValidationTests(loops[i], allInstanceBytes[i], schemaBoundValidator[i]);
        }
    }

    private void doValidationTests(int loops, FileCache.CachedFile file,
            Validator schemaValidator) throws
            ParserConfigurationException, IOException, SAXException {
        for (int i = loops - 1; i >= 0; i--) {
            validateSource(i, createDomSource(file), schemaValidator);
            validateSource(i, createSaxSource(file), schemaValidator);
        }
    }

    private void validateSource(int loop, Source source, Validator schemaValidator) {
        schemaValidator.reset();
        schemaValidator.setErrorHandler(null);
        try {
            schemaValidator.validate(source);
			// RPG_EDIT: Output is ommited in the rpg project
            /*if (loop == 0) {
                Context.getOut().print("\tas " + source.getClass().getName());
                Context.getOut().println(" succeeded. (correct result)");
            }*/
        } catch (SAXException e) {
            System.err.print("\tas " + source.getClass().getName());
            System.err.println(" failed. (Incorrect result)" + Arrays.toString(loops));
        //    e.printStackTrace(Context.getOut());
        } catch (IOException e) {
            System.err.println("Unable to validate due to IOException.");
        }
    }
}
