/**
 * This is a SPECjvm2008 benchmark "xml". The original source code in this file
 * is a subject to the following copyright:
 *
 * Copyright (c) 2008 Standard Performance Evaluation Corporation (SPEC)
 *               All rights reserved.
 *
 * This source code is provided as is, without any express or implied warranty.
 */
package rpg.modules.xml;

import rpg.Module;
import rpg.ModuleTimed;
import rpg.modules.common.FileCache;

import java.io.File;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;

import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;


public abstract class XMLBenchmark extends ModuleTimed {
    
    protected DocumentBuilderFactory documentBuilderFactory;
    protected SAXParserFactory SAXfactory;
    protected ReportingHandler callbackReporter = new ReportingHandler();
    protected DocumentBuilder builder;
    protected SAXParser saxParser;
    protected XMLReader xmlParser;

    public static final String XML_VALIDATION_INPUT_DIR_PROP =
            "input/xml.validation";
    public static final String XML_TRANSFORM_INPUT_DIR_PROP =
            "input/xml.transform";
    public static final String XML_TRANSFORM_OUT_DIR_PROP = "xml_out";
    
	public XMLBenchmark() {
        SAXfactory = SAXParserFactory.newInstance();
        SAXfactory.setNamespaceAware(true);
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            builder = documentBuilderFactory.newDocumentBuilder();
            builder.setErrorHandler(callbackReporter);
            builder.setEntityResolver(callbackReporter);
            saxParser = SAXfactory.newSAXParser();
            xmlParser = saxParser.getXMLReader();
            xmlParser.setErrorHandler(callbackReporter);
            xmlParser.setEntityResolver(callbackReporter);
        } catch (ParserConfigurationException e) {
            e.printStackTrace(System.err);
        } catch (SAXException e) {
            e.printStackTrace(System.err);
        }
    }
    
    public Source createDomSource(FileCache.CachedFile cachedInput)
    throws SAXException, IOException {
        return new DOMSource(builder.parse(cachedInput.asNewInputSource()));
    }
    
    public Source createSaxSource(FileCache.CachedFile cachedInput) throws IOException {
        return new SAXSource(xmlParser, cachedInput.asNewInputSource());
    }
    
    public static String getFullName(String dirName, String name) {
        String suffix = File.separator + name;        
        return dirName + suffix;
    }  
   
    public static FileCache.CachedFile getCachedFile(String dirName, String name) {
        FileCache.CachedFile result = FileCache.getFileCache().new CachedFile(getFullName(
                dirName,
                name));
        try {
            result.cache();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
    
    public static void remove(File file) {
        if (!file.isDirectory()) {
            file.delete();
        } else {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; i ++) {
                remove(files[i]);
            }
            file.delete();
        }
    }
}
