package rpg.modules.waiter;

import rpg.ModuleTimed;
import rpg.Rand;
import rpg.SessionStateHolder;

public class WaiterModule extends ModuleTimed {
	// FIXME: read configuration to determine wait time
	private final long WAIT_RANGE_MIN = 50000;
	private final long WAIT_RANGE_MAX = 999999;

	@Override
	public void init() {
		/* do nothing here */
	}

	@Override
	protected void internalWork (SessionStateHolder sessionState) {
		long sleeptimeMicrosec = Rand.randUint32() %
				(WAIT_RANGE_MAX - WAIT_RANGE_MIN + 1) + WAIT_RANGE_MIN;
		long sleeptimeMilisec = sleeptimeMicrosec / 1000;
		int sleeptimeNanosec = (int)(sleeptimeMicrosec % 1000) * 1000;
		try {
			Thread.sleep(sleeptimeMilisec, sleeptimeNanosec);
		}
		catch(InterruptedException e) {
			System.err.println("Thread sleep in work() was interrupted.");
		}
	}

}
