/**
 * This is a SPECjvm2008 benchmark "serial". This file, originally Main.java,
 * is the only file edited in this particular benchmark to connect it with
 * the Random program generator harness instead of the original one. The other
 * files have only their package declaration changed. The original source code
 * in this file is a subject to the following copyright:
 *
 * Copyright (c) 2008 Standard Performance Evaluation Corporation (SPEC)
 *               All rights reserved.
 *
 * This source code is provided as is, without any express or implied warranty.
 */
package rpg.modules.serial;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.BitSet;

import rpg.ModuleTimed;
import rpg.SessionStateHolder;
import rpg.StopBenchmarkException;


public class SerialModule extends ModuleTimed {
	static boolean doEquals=true;

    public Object[] threadInstances;
    ByteArrayOutputStream bos;


	@Override
	public void init () {
		/* do nothing here */
	}

	@Override
	protected void internalWork (SessionStateHolder sessionState) {
		try {
			setupBenchmark();

		    serialize();
            serialize();
            serialize();
    	}
		catch (StopBenchmarkException e) {
			System.err.println(e.getMessage());
		}
		catch (Exception e) {
    		e.printStackTrace();
    	}
    }

    public void setupBenchmark(){
        try {
            threadInstances = Utils.createInstances();
			bos = new ByteArrayOutputStream() {
				@Override
				public synchronized byte[] toByteArray() {
					return buf;
				}
			};
		} catch (Exception e) {
        	e.printStackTrace();
        	throw new StopBenchmarkException(
					"Error in initialization of serial module.");
        }
    }

	public void serialize() throws Exception {
    	BitSet result = Utils.createBitSet();
    	bos.reset();
    	ObjectOutputStream oos = new ObjectOutputStream(bos);
    	for (int i = 0; i < Utils.singleLoop; i ++) {
    	    for (int j = 0; j < threadInstances.length; j ++) {
    	    	oos.writeObject(threadInstances[j]);
    	    }
    	    oos.flush();
    	    oos.reset();
    	}

    	ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray(), 0, bos.size());
    	ObjectInputStream ois = new ObjectInputStream(bis);
    	for (int i = 0; i < Utils.singleLoop; i ++) {
    	    for (int j = 0; j < threadInstances.length; j ++) {
    	    	Object obj = ois.readObject();
    	    	if (doEquals) {
    	    	    result.set(j, result.get(j) && obj.equals(threadInstances[j]));
    	    	}
    	    }

    	}
    	oos.close();
    	ois.close();
		// Throw away the results, only time in the harness concerns us.
    	//Utils.printResult(System.out, result);
    }
}
