package rpg.modules.sequential;

import rpg.Module;
import rpg.ModuleTimed;
import rpg.SessionStateHolder;

public class SequentialModule extends ModuleTimed {
	private Module[] modules;

	@Override
	public void init() {
		throw new AssertionError ("Called init () with no submodules on architectural module");
	}

	@Override
	public void init (Module... modules_) {
		int moduleCount = modules_.length;
		assert (moduleCount >= 2);

		modules = new ModuleTimed[moduleCount];

		int i = 0;
		for (Module m : modules_) {
			modules[i] = m;
			i++;
		}
	}
	
	@Override
	protected void internalWork (SessionStateHolder sessionState) {
		for (Module m : modules) {
			m.measuredWork (sessionState);
		}
	}
}