/**
 * This is a SPECjvm2008 benchmark "crypto.rsa". This file was originally
 * Main.java.  The original source code in this file is a subject to
 * the following copyright:
 *
 * Copyright (c) 2008 Standard Performance Evaluation Corporation (SPEC)
 *               All rights reserved.
 *
 * This source code is provided as is, without any express or implied warranty.
 */

package rpg.modules.rsa;

import rpg.ModuleTimed;
import rpg.SessionStateHolder;
import rpg.StopBenchmarkException;
import rpg.Synchronized;
import rpg.modules.common.FileCache;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;

import javax.crypto.Cipher;

import rpg.modules.crypto.Util;

/**
 * Run this in single mode.
 * No multi threading for this benchmark right now.
 */
@Synchronized
public class RsaModule extends ModuleTimed {
    
    final static int level = 1;
    
    static PublicKey rsaPub;
    static PrivateKey rsaPriv;
    
	private static boolean isSetUp = false;

	@Override
	public void init () {
		if (!isSetUp) {
			setupBenchmark ();
			isSetUp = true;
		}
	}

	@Override
	protected void internalWork (SessionStateHolder sessionState) {
		runBenchmark ();
	}
    
    public byte [] encrypt(byte[] indata, String algorithm) {
        
        try {
            Cipher c = Cipher.getInstance(algorithm);
            byte[] result = indata;
            
            c.init(Cipher.ENCRYPT_MODE, rsaPub);
            result = c.doFinal(result);
            
            return result;
            
        } catch (Exception e) {
            throw new StopBenchmarkException("Exception in encrypt for " + algorithm + ".", e);
        }
    }
    
    public byte[] decrypt(byte[] indata, String algorithm) {
        
        try {
            Cipher c = Cipher.getInstance(algorithm);
            
            byte[] result = indata;
            
            c.init(Cipher.DECRYPT_MODE, rsaPriv);
            result = c.doFinal(result);
            
            return result;
            
        } catch (Exception e) {
            throw new StopBenchmarkException("Exception in decrypt for " + algorithm + ".", e);
        }
    }
    
    public void runSingleEncryptDecrypt(String algorithm, String inputFile) {
        byte [] indata = Util.getTestData(inputFile);
        // RPG_EDIT: output is ommited in rpg project
        //Context.getOut().println("Algorithm=" + algorithm + " indata length=" + indata.length);
        byte [] cipher = encrypt(indata, algorithm);
        byte [] plain = decrypt(cipher, algorithm);
        // RPG_EDIT: output is ommited in rpg project
        /*boolean match = */Util.check(indata, plain);
        //Context.getOut().println(algorithm + ":"
        //        + " plaincheck=" + Util.checkSum(plain)
        //        + (match ? " PASS" : " FAIL"));
    }
    
    public void runMultiEncryptDecrypt(String algorithm, String inputFile) {
        int blockSize = 64;
        byte [] fullIndata = Util.getTestData(inputFile);
        byte [] indata = new byte[blockSize];
        int pass = 0;
        int fail = 0;
        int check = 0;
        // RPG_EDIT: output is ommited in rpg project
        //Context.getOut().println("Algorithm=" + algorithm + " indata length=" + fullIndata.length);
        for (int i = 0; i + blockSize < fullIndata.length; i+= blockSize) {
            System.arraycopy(fullIndata, i, indata, 0, blockSize);
            byte [] cipher = encrypt(indata, algorithm);
            byte [] plain = decrypt(cipher, algorithm);
            if (Util.check(indata, plain)) {
                pass++;
                check += Util.checkSum(plain);
            } else {
                fail++;
            }
        }
        // RPG_EDIT: output is ommited in rpg project
        //Context.getOut().println(algorithm + ":"
        //        + " checksum=" + check
        //        + " pass=" + pass
        //        + " fail=" + fail);
    }

    public void runBenchmark() {
        runSingleEncryptDecrypt("RSA/ECB/PKCS1Padding", Util.TEST_DATA_3);
        runMultiEncryptDecrypt("RSA/ECB/PKCS1Padding", Util.TEST_DATA_5);
        // Run some more, in order to increase operation workload.
        runSingleEncryptDecrypt("RSA/ECB/PKCS1Padding", Util.TEST_DATA_3);
        runMultiEncryptDecrypt("RSA/ECB/PKCS1Padding", Util.TEST_DATA_5);
        runSingleEncryptDecrypt("RSA/ECB/PKCS1Padding", Util.TEST_DATA_3);
    }

	public static void setupBenchmark() {
        try {
            FileCache.getFileCache().loadFile(Util.TEST_DATA_3);
			//RPG_EDIT: It seems they load TEST_DATA_5 in both rsa and
			// signverify, how do they not get an exception I don't know
			// added check if it is already there
            if(!FileCache.getFileCache().hasFile(Util.TEST_DATA_5))
				FileCache.getFileCache().loadFile(Util.TEST_DATA_5);
            
            KeyPairGenerator rsaKeyPairGen = KeyPairGenerator.getInstance("RSA");
            // 512, 768 and 1024 are commonly used
            rsaKeyPairGen.initialize(1024);
            
            KeyPair rsaKeyPair = rsaKeyPairGen.generateKeyPair();
            
            rsaPub = rsaKeyPair.getPublic();
            rsaPriv = rsaKeyPair.getPrivate();
            
        } catch (Exception e) {
            throw new StopBenchmarkException("Error in setup of crypto.aes." + e);
        }
    }
    
}
