/**
 * This is a SPECjvm2008 benchmark "mpegaudio". This file was originally
 * Main.java.  The original source code in this file is a subject to
 * the following copyright:
 *
 * Copyright (c) 2008 Standard Performance Evaluation Corporation (SPEC)
 *               All rights reserved.
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * This source code is provided as is, without any express or implied warranty.
 */
package rpg.modules.mpegaudio;

import rpg.ModuleTimed;
import rpg.SessionStateHolder;
import rpg.Synchronized;

/**
 * Run this in single mode.
 * No multi threading for this benchmark right now.
 */
@Synchronized
public class MpegaudioModule extends ModuleTimed {
    
	public static final String prefix = "input/mpegaudio/";
    
	@Override
	public void init() {
		/* do nothing here */
	}

	/** Does a module's work. */
	@Override
	protected void internalWork (SessionStateHolder sessionState) {
		// RPG_EDIT: parameter seems to only control the order of files decoded,
		// so lets ignore it for now
		runBenchmark(0);
    }

	static void runBenchmark (int btid) {
        try {
            new Harness().inst_main(btid);
        } catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
    
}
