/**
 * This is a SPECjvm2008 benchmark "scimark.monte_carlo". This file was
 * originally Main.java.  The original source code in this file is a subject to
 * the following copyright:
 *
 * Copyright (c) 2008 Standard Performance Evaluation Corporation (SPEC)
 *               All rights reserved.
 *
 * This source code is provided as is, without any express or implied warranty.
 */

package rpg.modules.montecarlo;

import rpg.ModuleTimed;
import rpg.SessionStateHolder;
import rpg.modules.scimark.utils.kernel;

public class MontecarloModule extends ModuleTimed {

	/** Init with no modules is valid in a leaf module */
	@Override
	public void init() {
		/* do nothing here */
	}

	/** Does a module's work. */
	@Override
	protected void internalWork (SessionStateHolder sessionState) {
		runBenchmark();
	}

    static void runBenchmark() {
        // Loop a few times, to create some more work in each ops.
        for (int i = kernel.MC_LOOPS; i > 0; i --) {
            MonteCarlo.main();
        }
    }
}