package rpg.modules.loop;

import rpg.ConfigReader;
import rpg.Module;
import rpg.ModuleTimed;
import rpg.SessionStateHolder;

public class LoopModule extends ModuleTimed {
	private final String CONFIG_LOOPCOUNT = "loopcount";

	private Module module;
	private int loopCount;

	/** Init with no modules is invalid in loop module */
	@Override
	public void init () {
		throw new AssertionError ("Called init () with no submodules on architectural module");
	}

	/** Initializes module with one module connected.
	 * @param modules_
	 */
	@Override
	public void init (Module... modules_) {
		int moduleCount = modules_.length;
		assert (moduleCount == 1);

		for (Module m : modules_) {
			module = m;
		}

		loopCount = ConfigReader.getIntItem(getName(),
					CONFIG_LOOPCOUNT);
	}

	
	@Override
	public void internalWork (SessionStateHolder sessionState) {
		for (int i = 0; i < loopCount; i++) {
			module.measuredWork (sessionState);
		}
	}
}
