/*
 * Copyright (c) 2008 Standard Performance Evaluation Corporation (SPEC)
 * All rights reserved.
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * Modified by Kaivalya M. Dixit & Don McCauley (IBM) to read input files This
 * source code is provided as is, without any express or implied warranty.
 */

package rpg.modules.compress;

import rpg.StopBenchmarkException;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.CRC32;

public final class Harness {
    public static final String[] FILES_NAMES = new String[] {
        "202.tar",
        "205.tar",
        "208.tar",
        "209.tar",
        "210.tar",
        "211.tar",
        "213x.tar",
        "228.tar",
        "239.tar",
        "misc.tar"};

	// RPG_EDIT: removed public declarations of non-public classes to avoid
	// warnings
    public static final int FILES_NUMBER = FILES_NAMES.length;
    public static final int LOOP_COUNT = 2;
    static Source[] SOURCES;
    public static byte[][] COMPRESS_BUFFERS;
    public static byte[][] DECOMPRESS_BUFFERS;
    // RPG_EDIT: removed
	// static Compress CB;
	// since all it has is static members. Instatiating such a class and calling
	// static members through it only causes warnings. Occurences of CB replaced
	// with Compress throughout the file

    
    public void runCompress(int btid) {
		// RPG_EDIT: Output is ommited in the rpg project
        //System.out.println("Loop count = " + LOOP_COUNT);
        for (int i = 0; i < LOOP_COUNT; i++) {
            for (int j = 0; j < FILES_NUMBER; j++) {
                Source source = SOURCES[j];
                OutputBuffer comprBuffer, decomprBufer;
                comprBuffer = Compress.performAction(source.getBuffer(),
                        source.getLength(),
                        Compress.COMPRESS,
                        COMPRESS_BUFFERS[btid - 1]);
                decomprBufer = Compress.performAction(COMPRESS_BUFFERS[btid - 1],
                        comprBuffer.getLength(),
                        Compress.UNCOMPRESS,
                        DECOMPRESS_BUFFERS[btid - 1]);
				// RPG_EDIT: Output is ommited in the rpg project
                //System.out.print(source.getLength() + " " + source.getCRC() + " ");
                //System.out.print(comprBuffer.getLength() + comprBuffer.getCRC() + " ");
                //System.out.println(decomprBufer.getLength() + " " + decomprBufer.getCRC());
            }
        }
    }
    
    public long inst_main(int btid) {
        long startTime = System.currentTimeMillis();
        runCompress(btid);
        return System.currentTimeMillis() - startTime;
    }

	// RPG_EDIT: added input directory parameter
    static void prepareBuffers(String inputFileDir) {
        SOURCES = new Source[FILES_NUMBER];
        for (int i = 0; i < FILES_NUMBER; i ++) {
				SOURCES[i] = new Source(inputFileDir + "/" + FILES_NAMES[i]);
        }
		// RPG_EDIT: only one thread is used, so:
		int currentNumberBmThreads = 1;
        DECOMPRESS_BUFFERS = new byte[currentNumberBmThreads][Source.MAX_LENGTH];
        COMPRESS_BUFFERS = new byte[currentNumberBmThreads][Source.MAX_LENGTH];
    }
    
    static class Source {
        private byte[] buffer;
        private long crc;
        private int length;
        static int MAX_LENGTH;
        
        public Source(String fileName) {
            buffer = fillBuffer(fileName);
            length = buffer.length;
            MAX_LENGTH = Math.max(length, MAX_LENGTH);
            CRC32 crc32 = new CRC32();
            crc32.update(buffer, 0, length);
            crc = crc32.getValue();
        }
        
        long getCRC() {
            return crc;
        }
        
        int getLength() {
            return length;
        }
        
        byte[] getBuffer() {
            return buffer;
        }
        
        private static byte[] fillBuffer(String fileName) {
            try {
                FileInputStream sif = new FileInputStream(fileName);
                int length = (int) new File(fileName).length();
                int counter = 0;
                
                // Only allocate size of input file rather than MAX - kmd
                // If compressed file is larger than input file this allocation
                // will fail and out of bound exception will occur
                // In real lie, compress will no do any compression as no
                // space is saved.-- kaivalya
                byte[] result = new byte[length];
                
                int bytes_read;
                while ((bytes_read = sif.read(result, counter,
                        (length - counter))) > 0) {
                    counter += bytes_read;
                }
                
                sif.close(); // release resources
                
                if (counter != length) {
					// RPG_EDIT: print on standart error output
                    System.err.println(
                            "Compress: ERROR reading test input file");
                }
                return result;
            } catch (IOException e) {
				// RPG_EDIT: print rather on standart error output, but better
				// to raise another exception
				//e.printStackTrace(System.err);
				throw new StopBenchmarkException("Compress module: " +
						e.getMessage());
            }
            // RPG_EDIT: unreachable now
            //return null;
        }
    }
}

