/**
 * This is a SPECjvm2008 benchmark "compress". This file was originally
 * Main.java.  The original source code in this file is a subject to
 * the following copyright:
 *
 * Copyright (c) 2008 Standard Performance Evaluation Corporation (SPEC)
 *               All rights reserved.
 *
 * Copyright (c) 1997,1998 Sun Microsystems, Inc. All rights reserved.
 *
 * This source code is provided as is, without any express or implied warranty.
 */

package rpg.modules.compress;

import rpg.ModuleTimed;
import rpg.SessionStateHolder;
import rpg.StopBenchmarkException;
import rpg.Synchronized;

/**
 * Run this in single mode.
 * No multi threading for this benchmark right now.
 */
@Synchronized
public class CompressModule extends ModuleTimed {
    public static final Harness HB = new Harness();
    public static final String inputFileDir = "input/compress";
    
    /** Init with no modules is valid in a leaf module */
	@Override
	public void init() {
		/* do nothing here */
	}

	/** Does a module's work. */
	@Override
	protected void internalWork (SessionStateHolder sessionState) {
		try {
			setupBenchmark ();
			runBenchmark ();
		}
		catch (StopBenchmarkException e) {
			System.err.println (e.getMessage());
			throw new RuntimeException (e);
		}
    }

    private static long runBenchmark () {
		// only one thread is used, so its id is 1
		return HB.inst_main (1);
    }
    
    private static void setupBenchmark () {
		// RPG_EDIT: added input directory parameter
        Harness.prepareBuffers(inputFileDir);
    }
}
