package rpg.modules.branch;

import rpg.Module;
import rpg.ModuleTimed;
import rpg.Rand;
import rpg.SessionStateHolder;

public class BranchModule extends ModuleTimed {
	private Module[] modules;

	/** Init with no modules is invalid in branch module */
	@Override
	public void init() {
		throw new AssertionError ("Called init () with no submodules on architectural module");
	}

	/** Initializes module with one module connected.
	 * @param modules_
	 */
	@Override
	public void init (Module... modules_) {
		int moduleCount = modules_.length;
		assert (moduleCount >= 2);

		modules = new Module[moduleCount];

		int i = 0;
		for (Module m : modules_) {
			modules[i] = m;
			i++;
		}
	}

	@Override
	protected void internalWork (SessionStateHolder sessionState) {
		modules[(int)Rand.randUint32() % modules.length].measuredWork (sessionState);
	}

}