# architectural modules (branch, loop, sequential, waiter)
JAVA_MOD_BASES += branch/BranchModule loop/LoopModule sequential/SequentialModule waiter/WaiterModule

# common
JAVA_MOD_BASES += $(addprefix common/, FileCache)

# crypto (aes, rsa, signverify) 
JAVA_MOD_BASES += crypto/Util aes/AesModule rsa/RsaModule signverify/SignverifyModule

# compress
JAVA_MOD_BASES += $(addprefix compress/, CompressModule Harness Compress)

# scimark (fft, lu, montecarlo, sor, sparse)
JAVA_MOD_BASES += $(addprefix scimark/utils/, Constants kernel Random Stopwatch)
JAVA_MOD_BASES += $(addprefix fft/, FFT FftModule)
JAVA_MOD_BASES += $(addprefix lu/, LU LuModule)
JAVA_MOD_BASES += $(addprefix montecarlo/, MonteCarlo MontecarloModule)
JAVA_MOD_BASES += $(addprefix sor/, SOR SorModule)
JAVA_MOD_BASES += $(addprefix sparse/, SparseCompRow SparseModule)

# mpegaudio
JAVA_MOD_BASES += $(addprefix mpegaudio/, MpegaudioModule Harness)

# serial
JAVA_SERIAL_BASES := $(addprefix data/, Handler Child InterfaceForProxy ProxiedClass TestArray TestArrayDouble TestArrayList TestBigInteger TestByteArray TestClassReferenceTest TestClassWithSQLDateOnly TestDomainObject TestExceptionReference TestExternalizable TestHandler TestHugeData TestParent TestPayload TestProxy TestReadResolve TestSimple TestWithBigDecimal TestWithFinalField )
JAVA_SERIAL_BASES += SerialModule Utils
JAVA_MOD_BASES += $(addprefix serial/, $(JAVA_SERIAL_BASES))

# xml
JAVA_MOD_BASES += $(addprefix xml/, ReportingHandler XMLBenchmark)
JAVA_MOD_BASES += $(addprefix xmltransform/, BaseOutputStream ExtOutputStream XmltransformModule)
JAVA_MOD_BASES += $(addprefix xmlvalidation/, XmlvalidationModule)

# package prefix
JAVA_MOD_BASES := $(addprefix rpg/modules/, $(JAVA_MOD_BASES))
