#ifndef PARAMMACROS_H_
#define PARAMMACROS_H_

/**
 * Param define and access macros
 *
 * !!! All values (including numeric) have to be specified as strings !!!
 */

namespace rip {

#define DEFINE_PARAM_NUMERIC(paramName) \
	mParams.defineParam<ParamNumeric>(paramName)

#define DEFINE_PARAM_NUMERIC_DEFVAL(paramName, defaultVal) \
	mParams.defineParam<ParamNumeric>(paramName, defaultVal)

#define DEFINE_PARAM_STRING(paramName) \
	mParams.defineParam<ParamString>(paramName)

#define DEFINE_PARAM_STRING_DEFVAL(paramName, defaultVal) \
	mParams.defineParam<ParamString>(paramName, defaultVal)

#define GET_CURRENT_NUMERIC(paramName) \
	mParams.getCurrent<ParamNumeric, int64_t>(paramName)

#define GET_CURRENT_STRING(paramName) \
	mParams.getCurrent<ParamString, std::string>(paramName)

}

#endif /*PARAMMACROS_H_*/
