#ifndef LOGGER_H_
#define LOGGER_H_

#include <iostream>
#include <fstream>

namespace rip {

#define logD Logger::get().logDebug()
#define logI Logger::get().logInfo()
#define logE Logger::get().logError()

/**
 * Cares about simple logging
 *
 *  Simple singleton - free it at the end (no wrapper)
 */
class Logger {

public:

	/**
	 * Get logger - singleton
	 */
	static Logger & get();

	/**
	 * Free logger
	 */
	static void free();

	/**
	 * Logs debug
	 *
	 * @return stream that can be used for debug logging
	 */
	std::ostream & logDebug();

	/**
	 * Logs info
	 *
	 * @return stream that can be used for info logging
	 */
	std::ostream & logInfo();

	/**
	 * Logs error
	 *
	 * @return stream that can be used for error logging
	 */
	std::ostream & logError();

private:
	Logger();
	~Logger();

	static Logger * mLogger;
};

}

#endif // LOGGER_H_
