#ifndef RESULTFILECONSTS_H_
#define RESULTFILECONSTS_H_

namespace rip {

// all constants used in input and output files

const char PATH_DELIM = '/';
const char EXT_DELIM = '.';

// --- config file consts ---

const char INI_PARAM_DELIM = ',';

const char  INI_PAPI_SET_DELIM = ';';

#define INI_RIP_MAIN "rip"

#define INI_PARAM_TYPE "type"
#define INI_PARAM_CPU "cpu"
#define INI_PARAM_SCHEDULE "schedule"

// --- resume file consts ---

// !!! this are consts to produce ini file
const char RESUME_PARAM_DELIM = '\n';
const char RESUME_VALUE_DELIM = '=';

const char RESUME_PN_VAL_DELIM = '-';

#define RESUME_PARAM_RESULT_DIR "resultDir"
#define RESUME_PARAM_ROUND_NUM "roundNum"

// --- result file consts ---

#define RESULTF_DIR_PREFIX string("plot") + PATH_DELIM

const char RESULTF_BENCH_NAME_DELIM = '-';
const char RESULTF_PARAM_DELIM = ',';
const char RESULTF_PARAM_VALUE_DELIM = '=';

const char RESULTF_COLS_DELIM = '\t';

#define RESULTF_RDTSC_CATEGORY "C"
#define RESULTF_PAPI_CATEGORY "P"

// main category is category for which result file is created always
// (even if there are no results for that benchmark)
// should be RESULTF_RDTSC_CATEGORY
#define RESULTF_MAIN_CATEGORY RESULTF_RDTSC_CATEGORY

}

#endif /*RESULTFILECONSTS_H_*/
