#ifndef CONVERT_H_
#define CONVERT_H_

// thx http://www.parashift.com/c++-faq-lite/misc-technical-issues.html

#include <iostream>
#include <sstream>
#include <string>
#include <typeinfo>

#include "exceptions.h"

namespace rip {

/**
 * Converts input param to string
 *
 * @param x data that will be converted to string
 * @return data converted to string
 */
template<typename T>
inline std::string toString(const T& x) {

	std::ostringstream o;

	if (!(o << x)) {
		throw new BadConversionException(std::string("Cannot convert ")
				+ typeid(x).name() + " to string");
	}

	return o.str();
}

/**
 * Converts string to template given param
 *
 * @tparam conversion result
 * @param s string that will be converted to value
 * @param failIfLeftoverChars if s contains some characters that cannot be
 *        converted, conversion will fail
 * @return data that contains value of passed string
 */
template<typename T>
inline T stringTo(const std::string& s, bool failIfLeftoverChars = true) {

	T x;
	std::istringstream i(s);
	char c;

	if (!(i >> x) || (failIfLeftoverChars && i.get(c))) {
		throw new BadConversionException(
				std::string("Cannot convert string to ") + typeid(x).name());
	}

	return x;
}

}

#endif /*CONVERT_H_*/
