#include "_module.h"

#include "atomic.h"
#include "exceptions.h"
#include "benchmarkfactory.h"

#include "memutils.h"
#include "parammacros.h"


using namespace std;
using namespace rip;

#include <cassert>

/** Constructor */
calculation::calculation (const std::string &name)
: module_default (name)
{
	memoryBlock = NULL;
}

void calculation::init (int count, ...) {
	assert (count == 0);

	s_stepsize.reset(		sprovider.createSource(name, CALCULATION_STEPSIZE, true));
	s_blocksize.reset(		sprovider.createSource(name, CALCULATION_BLOCKSIZE, true));
	s_mem_cycles.reset(	sprovider.createSource(name, CALCULATION_MEMYCLES));
	s_comp_cycles.reset(	sprovider.createSource(name, CALCULATION_CYCLES));

	blocksize		= s_blocksize->getIntValue ();
	size_t stepsize	= s_stepsize->getIntValue ();

    // Some sanity checks on the arguments
	if (blocksize < blocksize) {
		error("Calculation: block size is smaller than blocksize");
		exit(EXIT_FAILURE);
	}
	if ((blocksize % stepsize) != 0) {
		error("Calculation: block size is not divisible by step size");
		exit(EXIT_FAILURE);
	}

    // Allocate and initialize the private memory block
    memoryBlock = MemInit::random (blocksize, stepsize);
}

void calculation::deinit () {
}

/** Virtual destructor */
calculation::~calculation() {
	mmapFree (memoryBlock, blocksize);
}


void calculation::internal_work (int &session_state)
{
		int memCycles       = s_mem_cycles->getIntValue ();
		int calculations    = s_comp_cycles->getIntValue ();

        // Initialize the traversal finger
        void **finger = memoryBlock;

        // Main benchmark loop
        for (int mem = 0; mem < memCycles; mem++) {

          // Traverse to the next value ...
          finger = (void **) *finger;

          // Do some useless calculation but make sure it
          // depends on the value so that it cannot be
          // reordered away ...
          size_t value = (size_t) finger;
          for (int calculationCycles = 0 ; calculationCycles < calculations ; calculationCycles ++)
          {
            value = value * 2 + 1;
          }
          volatile size_t __attribute__ ((unused)) result = value;

        } 
}
