#include "module.h"

#include "memutils.h"
#include "nopfunction.h"

//--------------------------------------------------------------------------
// Calculation

#define CALCULATION_BLOCKSIZE	"blocksize"
#define CALCULATION_STEPSIZE	"stepsize"
#define CALCULATION_MEMYCLES	"mem-cycles"
#define CALCULATION_CYCLES		"comp-cycles"

class calculation : public module_default {
private:
	std::auto_ptr<rpg::dataSource> s_stepsize;
	std::auto_ptr<rpg::dataSource> s_blocksize;
	std::auto_ptr<rpg::dataSource> s_mem_cycles;
	std::auto_ptr<rpg::dataSource> s_comp_cycles;

	/** Memory traversal block */
	void **memoryBlock;
	size_t blocksize;

public:
	/** Constructor, only sets ptr to NULL - for safe purposes */
	calculation (const std::string &name);

	/** Initializes the module */
	virtual void init (int count, ...);

	/** Deinitializes the module */
	virtual void deinit ();

	/** Does a module's work - waiter */
	virtual void internal_work (int &session_state);

	/** Virtual destructor */
	virtual ~calculation();
};


//--------------------------------------------------------------------------
// FFT

#define FFT_METHOD						"method"
#define FFT_BUFSIZE						"bufsize"

#include <fftw3.h>

class fft : public module_default {
private:
	std::auto_ptr<rpg::dataSource> s_method;
	std::auto_ptr<rpg::dataSource> s_bufsize;

	fftw_complex *fft_in;
	fftw_complex *fft_out;

	fftw_plan fft_plan;

public:
	/** Constructor, only sets ptr to NULL - for safe purposes */
	fft (const std::string &name);

	/** Initializes the module */
	virtual void init (int count, ...);

	/** Deinitializes the module */
	virtual void deinit ();

	/** Does a module's work - fft */
	virtual void internal_work (int &session_state);

	/** Virtual destructor */
	virtual ~fft();
};


//--------------------------------------------------------------------------
// Interleave

#define INTERLEAVE_BLOCKSIZE			"blocksize"
#define INTERLEAVE_STEPSIZE				"stepsize"
#define INTERLEAVE_POINTERS				"pointers"
#define INTERLEAVE_HOPS					"hops"

class interleave : public module_default {
private:
	std::auto_ptr<rpg::dataSource> s_stepsize;
	std::auto_ptr<rpg::dataSource> s_blocksize;
	std::auto_ptr<rpg::dataSource> s_pointers;
	std::auto_ptr<rpg::dataSource> s_hops;

	void **memoryBlock;
	size_t blocksize;
	int pointers;
	size_t steps;
	void ***fingers;

public:
	/** Constructor, only sets ptr to NULL - for safe purposes */
	interleave (const std::string &name);

	/** Initializes the module */
	virtual void init (int count, ...);

	/** Deinitializes the module */
	virtual void deinit ();

	/** Does a module's work - waiter */
	virtual void internal_work (int &session_state);

	/** Virtual destructor */
	virtual ~interleave();
};


//--------------------------------------------------------------------------
// MemSpeedMP

#define MEMSPEEDMP_ACCESS_METHOD		"access"
#define MEMSPEEDMP_STEPSIZE				"stepsize"
#define MEMSPEEDMP_MEMSIZE				"memsize"
#define MEMSPEEDMP_WRITE				"write"
#define MEMSPEEDMP_POINTERS				"pointers"

class memspeedmp : public module_default {
private:
	std::auto_ptr<rpg::dataSource> s_access;
	std::auto_ptr<rpg::dataSource> s_stepsize;
	std::auto_ptr<rpg::dataSource> s_memsize;
	std::auto_ptr<rpg::dataSource> s_write;
	std::auto_ptr<rpg::dataSource> s_pointers;

	rip::MemTrails mt;

	int pointers;
	size_t steps;

public:
	/** Constructor, only sets ptr to NULL - for safe purposes */
	memspeedmp (const std::string &name);

	/** Initializes the module */
	virtual void init (int count, ...);

	/** Deinitializes the module */
	virtual void deinit ();

	/** Does a module's work - waiter */
	virtual void internal_work (int &session_state);

	/** Virtual destructor */
	virtual ~memspeedmp();
};


//--------------------------------------------------------------------------
// Thrasher

#define TRASHER_ACCESS_METHOD			"access"
#define TRASHER_STEPSIZE				"stepsize"
#define TRASHER_MEMSIZE					"memsize"
#define TRASHER_WRITE					"write"
#define TRASHER_NOPCOUNT				"nopcount"
#define TRASHER_MAXNOPSINFUNC			"maxnopsinfunc"
#define TRASHER_POINTERS				"pointers"
#define TRASHER_STEPS					"steps"

class thrasher : public module_default {
private:
	std::auto_ptr<rpg::dataSource> s_access;
	std::auto_ptr<rpg::dataSource> s_stepsize;
	std::auto_ptr<rpg::dataSource> s_memsize;
	std::auto_ptr<rpg::dataSource> s_write;
	std::auto_ptr<rpg::dataSource> s_nopcount;
	std::auto_ptr<rpg::dataSource> s_maxnops;
	std::auto_ptr<rpg::dataSource> s_pointers;
	std::auto_ptr<rpg::dataSource> s_steps;

	rip::MemTrails mt;
	rip::NopFunction nopFunc;

	int pointers;
	size_t steps;

public:
	/** Constructor, only sets ptr to NULL - for safe purposes */
	thrasher (const std::string &name);

	/** Initializes the module */
	virtual void init (int count, ...);

	/** Deinitializes the module */
	virtual void deinit ();

	/** Does a module's work - waiter */
	virtual void internal_work (int &session_state);

	/** Virtual destructor */
	virtual ~thrasher();
};
