#include <string>
#include <assert.h>
#include <string.h>
#include <sys/mman.h>
#include <iostream>
#include <algorithm>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "_module.h"

#include "compress42.h"

using namespace std;

#define LZW_MAGIC_FD	42

int open_callback(const char *pathname, int flags)
{
//	cout << "Want open: " << pathname << endl;
	if (lzw::compress_filename != pathname) {
		cerr << "unexpected pathname in open from compress: " << pathname << endl;
		exit(EXIT_FAILURE);
	}
	if (lzw::read_offset != -1) {
		cerr << "multiple open from compress: " << pathname << endl;
		exit(EXIT_FAILURE);
	}
	lzw::read_offset = 0;
	return LZW_MAGIC_FD;
}

ssize_t read_callback(int fd, void *buf, size_t count)
{
//	cout << "Want read: " << count << " from " << fd << endl;

	if (fd != LZW_MAGIC_FD) {
		cerr << "compress reading from unexpected fd " << fd << endl;
		exit(EXIT_FAILURE);
	}

	size_t will_read = min (count, (size_t) (lzw::filesize - lzw::read_offset));

	if (will_read > 0) {
		memcpy(buf, lzw::fileBuffer + lzw::read_offset, will_read);
		lzw::read_offset += will_read;
	}

	return will_read;
//	return read(fd, buf, count);
}

ssize_t write_callback(int fd, const void *buf, size_t count)
{
//	cout << "Written: " << count << endl;
	return count;
}

int close_callback(int fd)
{
	if (fd == LZW_MAGIC_FD) {
		lzw::read_offset = -1;
		return 0;
	} else {
		cerr << "compress closing unexpected fd " << fd;
		exit(EXIT_FAILURE);
	}
}

using namespace std;
using namespace rpg;

#include <cassert>

char * lzw::fileBuffer = NULL;
string lzw::compress_filename;
ssize_t lzw::filesize;
ssize_t lzw::read_offset = -1;

/** Constructor */
lzw::lzw (const std::string &name)
: module_default (name)
{
	set_synchronized ();
}

void lzw::init (int count, ...) {
	assert (count == 0);

	s_filename.reset(	sprovider.createSource(name, LZW_FILENAME, true));
	s_maxbits.reset(	sprovider.createSource(name, LZW_MAXBITS));

	string filename = s_filename->getStringValue();

	/* prefill the file buffer, only once since the instance is in fact shared */
	if (fileBuffer == NULL) {
		compress_filename = filename;

		int file = open (filename.c_str(), O_RDONLY);
		if (file == -1) {
			perror ("lzw::init open ()");
			exit (EXIT_FAILURE);
		}

		filesize = lseek (file, 0, SEEK_END);
		if (filesize == -1) {
			perror ("lzw::init lseek (END)");
			exit (EXIT_FAILURE);
		}

		if (lseek (file, 0, SEEK_SET) == -1) {
			perror ("lzw::init lseek (START)");
			exit (EXIT_FAILURE);
		}

		fileBuffer = (char *) malloc (filesize);

		if (fileBuffer == NULL) {
			cerr << "lzw::init malloc () returned NULL";
			exit (EXIT_FAILURE);
		}

		char * read_pos = fileBuffer;
		ssize_t remaining = filesize;
		while (remaining > 0) {
			int read_now = read (file, read_pos, remaining);
			if (read_now == -1) {
				perror ("lzw::init read ()");
				exit (EXIT_FAILURE);
			}
			if (read_now == 0) {
				perror ("lzw::init read () == 0");
				exit (EXIT_FAILURE);
			}
			read_pos += read_now;
			remaining -= read_now;
		}
	}
}

void lzw::deinit () {
	if (fileBuffer != NULL) {
		free (fileBuffer);
		fileBuffer = NULL;
	}
}

/** Virtual destructor */
lzw::~lzw() {
}

/** Work procedure */
void lzw::internal_work (int &session_state)
{
	int compress_maxbits	 = s_maxbits->getIntValue();

	char ** argv = new char * [5];
	argv[0] = (char *) "compress";
	argv[1] = (char *) "-cb";
	argv[2] = new char[3];
	snprintf(argv[2], 3, "%d", compress_maxbits);
	argv[3] = (char *) "-f";
	argv[4] = new char[compress_filename.length() + 1];
	strcpy(argv[4], compress_filename.c_str());

	compress_main(5, argv);

	delete[] argv[4];
	delete[] argv[2];
	delete[] argv;
}
