#include "module.h"
#include <string>

//--------------------------------------------------------------------------
// LZW

#define LZW_FILENAME					"filename"
#define LZW_MAXBITS						"maxbits"

class lzw : public module_default {
private:
	std::auto_ptr<rpg::dataSource> s_filename;
	std::auto_ptr<rpg::dataSource> s_maxbits;

public:
	static char * fileBuffer;
	static std::string compress_filename;
	static ssize_t filesize;
	static ssize_t read_offset;

	/** Constructor */
	lzw (const std::string &name);

	/** Initializes the module */
	virtual void init (int count, ...);

	/** Deinitializes the module */
	virtual void deinit ();

	/** Does a module's work - lzw */
	virtual void internal_work (int &session_state);

	/** Virtual destructor */
	virtual ~lzw();
};
