#include <cassert>
#include <cstdlib>

#include <unistd.h>

#include <time.h>

#include "_module.h"


using namespace std;
using namespace rpg;

waiter::waiter (const std::string &name)
: module_default (name)
{
}

void waiter::init (int count, ...) {
	assert (count == 0);

	wait_ms.reset(sprovider.createSource(name, CONFIG_WAIT_MS));
}

/** Waits for the given time interval. */
void waiter::internal_work (int &session_status) {

	struct timespec ts;
	ts.tv_sec = 0;
	ts.tv_nsec = wait_ms->getIntValue() * (1000 * 1000);

	clock_nanosleep (CLOCK_MONOTONIC, 0, &ts, NULL);
}

void waiter::deinit () {
}

waiter::~waiter () {
}
