#include <cassert>
#include <cstdarg>
#include <cstdlib>

#include "_module.h"

/** Constructor */
sequential::sequential (const std::string &name)
: module_default (name)
{
	module_count = 0;
	ptr = NULL;
}

/** Initializes module with one module connected. */
void sequential::init (int count, ...) {
	assert (count >= 2);

	module_count = count;
	ptr = new module_ptr[count];

	va_list args;
	va_start(args, count);
	for (int i = 0; i < count; i++) {
		ptr[i] = va_arg(args, module_ptr);
	}
	va_end(args);
}

/** Does a module's work - sequential */
void sequential::internal_work (int &session_value) {
	for (int i = 0; i < module_count; i++) {
		ptr[i]->measured_work (session_value);
	}
}

void sequential::deinit () {
}

/** Virtual destructor */
sequential::~sequential () {
	delete[] ptr;
	ptr = NULL;
}
