#include <cassert>
#include <cstdarg>

#include "_module.h"

using namespace std;
using namespace rpg;

/** Constructor */
loop::loop (const std::string &name)
: module_default (name)
{
	ptr = NULL;
}

/** Initializes module with one module connected. */
void loop::init (int count, ...) {
	assert (count == 1);

	va_list args;
	va_start(args, count);
	ptr = va_arg(args, module_ptr);
	va_end(args);

	loopcount.reset(sprovider.createSource(name, CONFIG_LOOPCOUNT));
}

/** Does a module's work - loop */
void loop::internal_work (int &session_value) {
	rpg_uint_t loops = loopcount->getIntValue();
	for (rpg_uint_t i = 0; i < loops; i++) {
		ptr->measured_work (session_value);
	}
}

void loop::deinit () {
}

/** Virtual destructor */
loop::~loop () {
	ptr = NULL;
}
