#include <cassert>
#include <cstdarg>
#include <cstdlib>

#include "_module.h"
#include "rand.h"

/** Constructor */
branch::branch (const std::string &name)
: module_default (name)
{
	module_count = 0;
	ptr = NULL;
}

/** Initializes module with one module connected. */
void branch::init (int count, ...) {
	assert (count >= 2);

	module_count = count;
	ptr = new module_ptr[count];

	va_list args;
	va_start(args, count);
	for (int i = 0; i < count; i++) {
		ptr[i] = va_arg(args, module_ptr);
	}
	va_end(args);
}

/** Does a module's work - branch */
void branch::internal_work (int &session_value) {
	ptr [rand_l () % module_count]->measured_work (session_value);
}

void branch::deinit () {
}

/** Virtual destructor */
branch::~branch () {
	delete[] ptr;
	ptr = NULL;
}
