#include "module.h"


//--------------------------------------------------------------------------
// Branch

class branch : public module_default {
private:
	int module_count;
	module_ptr* ptr;
public:
	branch (const std::string &name);
	virtual void init (int count, ...);
	virtual void deinit ();
	virtual void internal_work (int &session_value);
	virtual ~branch ();
};


//--------------------------------------------------------------------------
// Dummy

class dummy : public module_default {
private:
public:
    dummy (const std::string &name);
    virtual void init (int count, ...);
    virtual void deinit ();
    virtual void internal_work (int &session_value);
    virtual ~dummy ();
};


//--------------------------------------------------------------------------
// Loop

class loop : public module_default {
private:
	module_ptr ptr;
	std::auto_ptr<rpg::dataSource> loopcount;
public:
	loop (const std::string &name);
	virtual void init (int count, ...);
	virtual void deinit ();
	virtual void internal_work (int &session_value);
	virtual ~loop ();
};


//--------------------------------------------------------------------------
// Sequential

class sequential : public module_default {
private:
	int module_count;
	module_ptr* ptr;
public:
	sequential (const std::string &name);
	virtual void init (int count, ...);
	virtual void deinit ();
	virtual void internal_work (int &session_value);
	virtual ~sequential ();
};


//--------------------------------------------------------------------------
// Waiter

/** Wait time in miliseconds */
#define CONFIG_WAIT_MS "wait-ms"

class waiter : public module_default {
private:
	std::auto_ptr<rpg::dataSource> wait_ms;
public:
	waiter (const std::string &name);
	virtual void init (int count, ...);
	virtual void deinit ();
	virtual void internal_work (int &session_value);
	virtual ~waiter();
};
