#include <assert.h>

#include "_module.h"

using namespace std;
using namespace rpg;

/** Constructor */
astar::astar (const std::string &name)
: module_default (name)
{
	set_synchronized ();
}

void astar::init (int count, ...) {
	assert (count == 0);
	s_filename.reset(	sprovider.createSource(name, ASTAR_FILENAME));
}

int __473astar_main(int argc, char* argv[]);

/** Does a module's work - astar */
void astar::internal_work (int &session_state) {
	const rpg_str_t & fname = s_filename->getStringValue();
	char** params = new char* [2];
	params[0] = const_cast<char *> ("astar modul!");
	params[1] = const_cast<char *> (fname.c_str ());
	__473astar_main(2, params);
	delete[] params;
}

void astar::deinit () {
}

/** Virtual destructor */
astar::~astar() {
}
