#include "module.h"

#include "main.h"

//--------------------------------------------------------------------------
// LBM

#define LBM_FILENAME					"filename"
#define LBM_STEPS						"steps"

class lbm : public module_default {
private:
	static std::auto_ptr<rpg::dataSource> s_filename;
	static std::auto_ptr<rpg::dataSource> s_steps;

	static double * srcGrid, * dstGrid;

	static MAIN_Param param;

	static bool initialized;

public:
	/** Constructor, only sets ptr to NULL - for safe purposes */
	lbm (const std::string &name);

    /** Initializes module with one module connected. */
    virtual void init (int count, ...);

	/** Deinitializes the module */
	virtual void deinit ();

	/** Does a module's work - waiter */
	virtual void internal_work (int &session_state);

	/** Virtual destructor */
	virtual ~lbm();
};
