#include <assert.h>
#include <stdlib.h>

#include "_module.h"

using namespace std;
using namespace rpg;

/** Constructor */
libquantum::libquantum (const std::string &name)
: module_default (name)
{
	set_synchronized ();
}

void libquantum::init (int count, ...) {
	assert (count == 0);
	s_n1.reset(	sprovider.createSource(name, LIBQUANTUM_NUMBER1));
	s_n2.reset(	sprovider.createSource(name, LIBQUANTUM_NUMBER2));
}

extern "C" {
int __462libquantum_main(int argc, char* argv[]);
}

/** Does a module's work - libquantum */
void libquantum::internal_work (int &session_state) {
	char** params = new char* [3];

	const int iI1 = s_n1->getIntValue ();
	const rpg_str_t sI1 = toString (iI1);

	const int iI2 = s_n2->getIntValue ();
	const rpg_str_t sI2 = toString (iI2);

	params[0] = const_cast<char *> ("libquantum modul!");
	params[1] = const_cast<char *> (sI1.c_str ());
	params[2] = const_cast<char *> (sI2.c_str ());
	__462libquantum_main(3, params);
	delete[] params;
}

void libquantum::deinit () {
}

/** Virtual destructor */
libquantum::~libquantum() {
}

