#include <assert.h>

#include "_module.h"

extern "C" {
	#include "sjeng.h"
	#include "protos.h"

	int __458sjeng_main_init (int argc, char *argv[]);
}

using namespace std;
using namespace rpg;

std::auto_ptr<rpg::dataSource> sjeng::s_filename;
bool sjeng::initialized = false;

/** Constructor */
sjeng::sjeng (const std::string &name)
: module_default (name)
{
	set_synchronized ();
}

void sjeng::init (int count, ...) {
	assert (count == 0);

	if (initialized) {
		return;
	}

	s_filename.reset(	sprovider.createSource(name, SJENG_FILENAME, true));

	const rpg_str_t & fname = s_filename->getStringValue();

	char** params = new char* [2];
	params[0] = const_cast<char *> ("sjeng modul!");
	params[1] = const_cast<char *> (fname.c_str ());

	__458sjeng_main_init(2, params);

	delete[] params;

	initialized = true;
}

/** Does a module's work - sjeng */
void sjeng::internal_work (int &session_state) {
	do_autotest();
}

void sjeng::deinit () {
	if (initialized) {
		cleanup_autotest();
		initialized = false;
	}
}
/** Virtual destructor */
sjeng::~sjeng() {
}
