#include <assert.h>

#include "_module.h"

using namespace std;
using namespace rpg;

int __444namd_main(int argc, char **argv);

/** Constructor */
namd::namd (const std::string &name)
: module_default (name)
{
	set_synchronized ();
}

void namd::init (int count, ...) {
	assert (count == 0);
	s_filename.reset(	sprovider.createSource(name, NAMD_FILENAME));
	s_iterations.reset(	sprovider.createSource(name, NAMD_ITER));
}


/** Does a module's work - namd */
void namd::internal_work (int &session_state) {
	const rpg_str_t & fname = s_filename->getStringValue ();

	const int iIter = s_iterations->getIntValue ();
	const rpg_str_t sIter = toString (iIter);


	char** params = new char* [5];
	params[0] = const_cast<char *> ("namd modul!");
	params[1] = const_cast<char *> ("--input");
	params[2] = const_cast<char *> (fname.c_str ());
	params[3] = const_cast<char *> ("--iterations");
	params[4] = const_cast<char *> (sIter.c_str());
	__444namd_main(5, params);
	delete[] params;
}

void namd::deinit () {
}

/** Virtual destructor */
namd::~namd() {
}
