#include "module.h"


//--------------------------------------------------------------------------
// NAMD

#define NAMD_FILENAME					"filename"
#define NAMD_ITER   					"iterations"

class namd : public module_default {
private:
	std::auto_ptr<rpg::dataSource> s_filename;
	std::auto_ptr<rpg::dataSource> s_iterations;
public:
	/** Constructor, only sets ptr to NULL - for safe purposes */
	namd (const std::string &name);

	/** Initializes module with one module connected. */
	virtual void init (int count, ...);

	/** Deinitializes the module */
	virtual void deinit ();

	/** Does a module's work - waiter */
	virtual void internal_work (int &session_state);

	/** Virtual destructor */
	virtual ~namd();
};
