#include <assert.h>

#include "_module.h"

#include "mcf.h"

using namespace std;
using namespace rpg;

std::auto_ptr<rpg::dataSource> mcf::s_filename;
bool mcf::initialized = false;;

/** Constructor */
mcf::mcf (const std::string &name)
: module_default (name)
{
	set_synchronized ();
}

void mcf::init (int count, ...) {
	assert (count == 0);

	if (!initialized) {
		s_filename.reset(	sprovider.createSource(name, MCF_FILENAME, true));
		initialized = true;
	}
}

/** Does a module's work - mcf */
void mcf::internal_work (int &session_state) {
	const rpg_str_t & fname = s_filename->getStringValue();
	char** params = new char* [2];
	params[0] = const_cast<char *> ("mcf modul!");
	params[1] = const_cast<char *> (fname.c_str ());
	__429mcf_main(2, params);
	delete[] params;
}

void mcf::deinit() {
}

/** Virtual destructor */
mcf::~mcf() {
}
