#include <assert.h>

#include "_module.h"

#include "spec.h"

using namespace std;
using namespace rpg;

std::auto_ptr<rpg::dataSource> bzip2::s_filename;
std::auto_ptr<rpg::dataSource> bzip2::s_inputsize;
bool bzip2::initialized = false;

/** Constructor */
bzip2::bzip2 (const std::string &name)
: module_default (name)
{
	set_synchronized ();
}

void bzip2::init (int count, ...) {

	assert (count == 0);

	// the instance is shared by all modules...
	if (!initialized) {

		s_filename.reset (sprovider.createSource (name, BZIP2_FILENAME, true));
		s_inputsize.reset (sprovider.createSource (name, BZIP2_INPUTSIZE, true));

		const rpg_str_t & fname = s_filename->getStringValue ();

		const int iInputsize = s_inputsize->getIntValue();
		const rpg_str_t sInputSize = toString (iInputsize);

		char** params = new char* [3];
		params[0] = const_cast<char *> ("bzip2 modul!");
		params[1] = const_cast<char *> (fname.c_str ());
		params[2] = const_cast<char *> (sInputSize.c_str ());
		__401bzip2_main (3, params);
		delete[] params;

		initialized = true;
	}

}

/** Does a module's work - bzip2 */
void bzip2::internal_work (int &session_state) {
	__401bzip2_work();
}

void bzip2::deinit () {
	if (initialized) {
		__401bzip2_finalize();
		initialized = false;
	}
}
/** Virtual destructor */
bzip2::~bzip2() {
}
